<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikanModel;

    public function __construct()
    {
        $this->pendidikanModel = new PendidikanModel();
    }

    // ===============================
    // FRONTEND (READ ONLY)
    // ===============================
    public function frontend()
    {
        return view('frontend/pendidikan', [
            'pendidikan' => $this->pendidikanModel
                ->orderBy('tahun_masuk', 'ASC')
                ->findAll()
        ]);
    }

    // ===============================
    // Backend
    // ===============================
    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $jenjang = $this->request->getGet('jenjang');
        $sort    = $this->request->getGet('sort') ?? 'id';
        $order   = $this->request->getGet('order') ?? 'asc';

        $query = $this->pendidikanModel;

        // 🔍 SEARCH
        if ($keyword) {
            $query = $query->like('nama_sekolah', $keyword)
                ->orLike('jurusan', $keyword);
        }

        // 🎛 FILTER
        if ($jenjang) {
            $query = $query->where('jenjang', $jenjang);
        }

        // ↕ SORTING + 📄 PAGINATION
        $data['pendidikan'] = $query->orderBy($sort, $order)
            ->paginate(10);

        $data['pager'] = $this->pendidikanModel->pager;

        return view('pendidikan/index', $data);
    }


    // ===============================
    // CREATE FORM
    // ===============================
    public function create()
    {
        return view('pendidikan/create');
    }

    // ===============================
    // STORE
    // ===============================
    public function store()
    {
        $file = $this->request->getFile('logo_sekolah');
        $logoName = null;

        if ($file && $file->isValid()) {
            $logoName = $file->getRandomName();
            $file->move('uploads/pendidikan', $logoName);
        }

        $this->pendidikanModel->save([
            'jenjang'        => $this->request->getPost('jenjang'),
            'nama_sekolah'   => $this->request->getPost('nama_sekolah'),
            'jurusan'        => $this->request->getPost('jurusan'),
            'logo_sekolah'   => $logoName,
            'tahun_masuk'    => $this->request->getPost('tahun_masuk'),
            'tahun_lulus'    => $this->request->getPost('tahun_lulus'),
        ]);

        return redirect()->to('/auth/pendidikan');
    }

    // ===============================
    // EDIT FORM
    // ===============================
    public function edit($id)
    {
        $data['pendidikan'] = $this->pendidikanModel->find($id);
        return view('pendidikan/edit', $data);
    }

    // ===============================
    // UPDATE
    // ===============================
    public function update($id)
    {
        $file = $this->request->getFile('logo_sekolah');
        $old  = $this->pendidikanModel->find($id);

        $logoName = $old['logo_sekolah'];

        if ($file && $file->isValid()) {
            $logoName = $file->getRandomName();
            $file->move('uploads/pendidikan', $logoName);
        }

        $this->pendidikanModel->update($id, [
            'jenjang'      => $this->request->getPost('jenjang'),
            'nama_sekolah' => $this->request->getPost('nama_sekolah'),
            'jurusan'      => $this->request->getPost('jurusan'),
            'logo_sekolah' => $logoName,
            'tahun_masuk'  => $this->request->getPost('tahun_masuk'),
            'tahun_lulus'  => $this->request->getPost('tahun_lulus'),
        ]);

        return redirect()->to('/auth/pendidikan');
    }


    // ===============================
    // DELETE
    // ===============================
    public function delete($id)
    {
        $this->pendidikanModel->delete($id);
        return redirect()->to('/auth/pendidikan');
    }
}
